# Unattended-install

This script allows to install and update iTop via CLI.

For more information, see the official Wiki : [Automated installation [iTop Documentation]](https://www.itophub.io/wiki/page?id=latest:advancedtopics:automatic_install)

# unattended-install.php

## Usage

Execution of the unattended installation
> Note:
> Because the installation runs from the command line, make sure that the current user has enough rights to access the different locations and that the web server will be able to access the files and directories created during the scripted installation. In order to exactly emulate the behavior of
the interactive installation it may be a good practice to run this installation from the user account used for running the web server process.

Launch the script with the following command:  ```bash php unattended_install.php --param-file=fresh-install.xml ```

Where: `fresh-install.xml` is the response file containing your desired settings for the installation (there are 4 models available in the folder `xml_setup`: fresh-install.xml, itil-fresh-install.xml, itil-upgrade.xml, upgrade.xml)

Fresh installation parameters
> Important:
> In the case of a fresh installation (<mode>install</mode>), do not forget to complete below mandatory parameters before:

```xml 
<database>
    <server></server>
    <user></user>
    <pwd></pwd>
    <name></name>
    <db_tls_enabled></db_tls_enabled>
    <db_tls_ca></db_tls_ca>
    <prefix></prefix>
</database>
<url>
</url>
<graphviz_path>/usr/bin/dot</graphviz_path>
<admin_account>
<user></user>
<pwd></pwd>
<language></language>
</admin_account>
<language></language>
```

## Options

To get all available options of the script, you can perform the following command :
```php unattended-install.php --help```

# install-itop.sh

## Usage

You can install your iTop by only using config-itop.php settings and run either

- a non-ITIL iTop fresh installation (use itil-fresh-install.xml to have ITIL modules instead)

```
./install-itop.sh ./xml_setup/fresh-install.xml
```

- a non-ITIL iTop upgrade (use itil-upgrade.xml to have ITIL modules instead)

```
./install-itop.sh ./xml_setup/upgrade.xml
```

- a specific iTop installation by providing both xml setup file
  in below example file provided is the one generated by iTop during last setup.

```
./install-itop.sh ../../log/install-2024-04-03.xml
```
